<?php
/****************************************
 * XKLog 搜索页
 *
 * 此文件控制输出搜索页，处理搜索请求
 *
 * 更新：2009-06-26
 * 版本：V1.0
 ****************************************/

require('./include/loader.php');
@header("content-Type: text/html; charset=utf-8");

$_ENV['title'] = "搜索";

// 参数处理
$search_word = safe_str_filter( getGP('word','G') );
$search_type = safe_str_filter( getGP('type','G') );

if( !empty( $search_word ) ) {
	if( $search_type == 'tag' ) {
		$_ENV['title'] = $_CACHE['tag'][$search_word]['T_Name'] . ' - 搜索';
	}else{
		$_ENV['title'] = $search_word . ' - 搜索';
	}
	search( $search_word, $search_type );
}else{
	main();
}

function main() {
	$temp = '<div id = "Main_Search"><form name="frm" action="search.php" method="get">';
	$temp .= '<table width="100%" cellspacing="0" cellpadding="0">';
	$temp .= '<tr><td colspan="2" align="center"><h3>搜索目标</h3></td></tr>';
	$temp .= '<tr>';
	$temp .= '<th width="50%">关键词：';
	$temp .= '<br /><input type="text" name="word" size="20" />';
	$temp .= '</th>';
	$temp .= '<th>搜索范围：';
	$temp .= '<br /><input type="radio" name="type" value="title" checked /> 标题 <input type="radio" name="type" value="tag" /> 标签 <input type="radio" name="type" value="content" /> 正文';
	$temp .= '</th></tr></table>';
	$temp .= '<div style="margin-bottom:25px;text-align:center;">';
	$temp .= '<input class="button" type="submit" name="submit" value="提 交" /> <input class="button" type="reset" value="重 置" /></div></form></div>';
	$_ENV['page']['content'] = $temp;
	template('page');
}

function search( $search_word, $search_type = 'title' ) {
	global $db,$_ENV,$_CACHE;
	//if CDate( DateDiff( "s", Session("PostDate"), Now() ) ) < CDate( BlogComTimer ) Then
	//	Search_Content = "<div style = ""text-align:center;margin:10px;""><strong>操作限制，请再等一会儿再进行搜索！</strong></div>"
	//	Exit function
	//End if
	if( $search_type == 'tag' ) {
		$sql = "Select ID,Title,Type,Address,Category From `" . PREFIX_STR . "Article` Where Tag like '%{*" . $search_word . "*}%' And IsDel=0 Order By ID Desc LIMIT 0,10";
	}elseif( $search_type == 'content' ) {
		if( user_is_login() ) {
			$sql = "Select ID,Title,Type,Address,Category From " . PREFIX_STR . "Article Where Content like '%" . $search_word . "%' And IsDel=0 Order By ID Desc LIMIT 0,10";
		}else{
			show_message( '只有注册用户才能搜索正文，请先注册或登录！', 'login.php' );
			exit;
		}
	}else{
		$sql = "Select ID,Title,Type,Address,Category From " . PREFIX_STR . "Article Where Title like '%" . $search_word . "%' And IsDel=0 Order By ID Desc LIMIT 0,10";
	}
	$search_arr = array();
	$search_arr = $db->fetch_all( $sql );
	if ( !count( $search_arr ) ) {
		$_ENV['page']['content'] = '<div style = "text-align:center;margin:10px;"><strong>没有搜索到任何内容！</strong></div>';
		template('page');
		exit;
	}

	if( $search_type == 'tag' ) {
		$temp = '<div id = "Main_Search"><h3>搜索结果</h3><br />搜索类型：标签<br />搜索关键字：' . $_CACHE['tag'][$search_word]['T_Name'] . '<ol>';
	}elseif( $search_type == 'content' ) {
		$temp = '<div id = "Main_Search"><h3>搜索结果</h3><br />搜索类型：正文<br />搜索关键字：' . $search_word . '<ol>';
	}else{
		$temp = '<div id = "Main_Search"><h3>搜索结果</h3><br />搜索类型：标题<br />搜索关键字：' . $search_word . '<ol>';
	}
	foreach( $search_arr as $value ) {
		if( $value['Type'] == '动态' ) {
			$temp .= '<li><a href = "' . BLOG_PATH . 'read.php?id=' . $value['ID'] . '" target="_blank" >' . $value['Title'] . '</a></li>';
		}elseif ( $value['Type'] == '半静态' ) {
			$temp .= '<li><a href = "' . BLOG_PATH . 'article/' . $_CACHE['category'][$value['Category']]['Alias'] . '/' . $value['Address'] . '.php" target="_blank" >' . $value['Title'] . '</a></li>';
		}else{
			$temp .= '<li><a href = "' . BLOG_PATH . 'article/' . $_CACHE['category'][$value['Category']]['Alias'] . '/' . $value['Address'] . '.html" target="_blank" >' . $value['Title'] . '</a></li>';
		}
	}
	$temp .= '</ol></div>';
	// Session("PostDate") = Now()
	$_ENV['page']['content'] = $temp;
	template('page');
}
?>